#ifndef __MOVINGCIRCLE_H
#define __MOVINGCIRCLE_H

#include "Circle.h"
    
class MovingCircle: public Circle {
public:
    enum { MAXFRAMESPERSECOND = 100 };
    MovingCircle(double radius=1, double centerX = 0,
                    double centerY = 0, double deltaX = 1, 
                    double deltaY = 1, int framesPerSecond = 20)
            :Circle(radius, centerX, centerY), deltaX(deltaX),
            deltaY(deltaY), framesPerSecond(framesPerSecond) {}
    MovingCircle operator + (const MovingCircle &mc) {
        MovingCircle result;
        (Circle &) result = (Circle&)(*this) + mc;
        double sumAreas = getArea() + mc.getArea();
        result.deltaX = 
            (deltaX*getArea()+mc.deltaX*mc.getArea())
                / sumAreas;
        result.deltaY = 
            (deltaY*getArea()+mc.deltaY*mc.getArea())
                / sumAreas;
        result.redlevel =     
            int((redlevel*getArea()+mc.redlevel*mc.getArea()) 
                / sumAreas + 0.5);
        result.greenlevel = 
            int((greenlevel*getArea()+
                mc.greenlevel*mc.getArea())/sumAreas + 0.5);
        result.bluelevel = 
            int((bluelevel*getArea()+
                mc.bluelevel*mc.getArea())/sumAreas + 0.5);
        return result;
    }
    // Access functions.
    double getDeltaX() const { return deltaX; }
    double getDeltaY() const { return deltaY; }
    void putFramesPerSecond(int count) {
        if (count <= 0) count = 1;
        if (count > MAXFRAMESPERSECOND) 
            count = MAXFRAMESPERSECOND;
        framesPerSecond = count;
    }
    MovingCircle operator++() {
        // Pre-increment.  Take the circle through one time 
        // unit of its life.
        centerX += deltaX/framesPerSecond;
        centerY += deltaY/framesPerSecond;
        return *this;
    }
    void randomizeDirection(int maxDelta) {
        deltaX = rand()%(2*maxDelta+1) - maxDelta;
        deltaY = rand()%(2*maxDelta+1) - maxDelta;
    }
    void randomizeColor() {
        redlevel = rand()%256;
        greenlevel = rand()%256;
        bluelevel = rand()%256;
    }
    void draw(CDC &dc) {
        CBrush brush(RGB(redlevel,greenlevel,bluelevel));
        CBrush * oldBrush = dc.SelectObject(&brush);
        Circle::draw(dc);
        dc.SelectObject(oldBrush);
    }
private:
    double deltaX, deltaY;  // Number of pixels traversed 
                            // in one second
    int redlevel, greenlevel, bluelevel;
    int framesPerSecond;
};

#endif
